@if (is_multilingual())
    <div
        x-data="{ open: false, selected: '{{ locale() }}' }"
        class="dropdown"
    >
        <div
            class="dropdown-button"
            :class="{ active: open }"
            @click="open = !open"
        >
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M7.99998 3H8.99998C7.04998 8.84 7.04998 15.16 8.99998 21H7.99998" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M15 3C16.95 8.84 16.95 15.16 15 21" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M3 16V15C8.84 16.95 15.16 16.95 21 15V16" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M3 8.99998C8.84 7.04998 15.16 7.04998 21 8.99998" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
            
            <span x-text="selected">{{ locale() }}</span> 
    
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path d="M19.9201 8.94995L13.4001 15.47C12.6301 16.24 11.3701 16.24 10.6001 15.47L4.08008 8.94995" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        </div> 
    
        <div x-cloak x-show="open" @click.outside="open = false" class="dropdown-menu">
            @foreach (supported_locales() as $locale => $language)
                <div
                    @click="
                        open = false;
                        selected = '{{ substr($locale, 0, 5) }}';
                        location = '{{ localized_url($locale) }}'
                    "
                    class="dropdown-item"
                >
                    {{ substr($locale, 0, 5) }}
                </div>
            @endforeach
        </div>
    </div>
@endif